-- phpMyAdmin SQL Dump
-- version 5.1.1
-- https://www.phpmyadmin.net/
--
-- Hôte : 127.0.0.1:3306
-- Généré le : jeu. 22 mai 2025 à 19:04
-- Version du serveur : 5.7.36
-- Version de PHP : 7.4.26

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `safimotors`
--

-- --------------------------------------------------------

--
-- Structure de la table `achat`
--

DROP TABLE IF EXISTS `achat`;
CREATE TABLE IF NOT EXISTS `achat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `fournisseur_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `total_paye` double DEFAULT NULL,
  `date_commande` datetime DEFAULT NULL,
  `date_miseajour` datetime DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `num_commande` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_cloture` tinyint(1) DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `total_livre` double DEFAULT NULL,
  `total_ht` double DEFAULT NULL,
  `total_tva` double DEFAULT NULL,
  `total_ttc` double DEFAULT NULL,
  `reliquat` double DEFAULT NULL,
  `total_retour` double DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `est_facturee` tinyint(1) DEFAULT NULL,
  `date_facturation` datetime DEFAULT NULL,
  `num_increment_facture` int(11) DEFAULT NULL,
  `num_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scan_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_26A98456FB88E14F` (`utilisateur_id`),
  KEY `IDX_26A98456670C757F` (`fournisseur_id`),
  KEY `IDX_26A9845620096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `achat_consignation`
--

DROP TABLE IF EXISTS `achat_consignation`;
CREATE TABLE IF NOT EXISTS `achat_consignation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `achat_id` int(11) DEFAULT NULL,
  `num_consignation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nbr_colis` int(11) DEFAULT NULL,
  `frais_livraison` double DEFAULT NULL,
  `date_livraison` datetime DEFAULT NULL,
  `date_reception` datetime DEFAULT NULL,
  `scan_bon_livraison` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `note` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_459EFD05FE95D117` (`achat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `achat_consignation_produit`
--

DROP TABLE IF EXISTS `achat_consignation_produit`;
CREATE TABLE IF NOT EXISTS `achat_consignation_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `achat_produit_id` int(11) DEFAULT NULL,
  `achat_consignation_id` int(11) DEFAULT NULL,
  `quantite` double NOT NULL,
  `note` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_A7DBF82D64846FF9` (`achat_produit_id`),
  KEY `IDX_A7DBF82DD62F262D` (`achat_consignation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `achat_livraison`
--

DROP TABLE IF EXISTS `achat_livraison`;
CREATE TABLE IF NOT EXISTS `achat_livraison` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `achat_id` int(11) DEFAULT NULL,
  `nbr_colis` int(11) DEFAULT NULL,
  `frais_livraison` double DEFAULT NULL,
  `date_livraison` datetime DEFAULT NULL,
  `date_reception` datetime DEFAULT NULL,
  `num_bon_livraison` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `note` longtext COLLATE utf8_unicode_ci,
  `scan_bon_livraison` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `num_bon_reception` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scan_bon_reception` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_7D4C694FFE95D117` (`achat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `achat_livraison_produit`
--

DROP TABLE IF EXISTS `achat_livraison_produit`;
CREATE TABLE IF NOT EXISTS `achat_livraison_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `achat_produit_id` int(11) DEFAULT NULL,
  `achat_livraison_id` int(11) DEFAULT NULL,
  `quantite` double NOT NULL,
  `note` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_CAA63A4464846FF9` (`achat_produit_id`),
  KEY `IDX_CAA63A44D6D2D2E5` (`achat_livraison_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `achat_produit`
--

DROP TABLE IF EXISTS `achat_produit`;
CREATE TABLE IF NOT EXISTS `achat_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produit_id` int(11) DEFAULT NULL,
  `achat_id` int(11) DEFAULT NULL,
  `quantite` double DEFAULT NULL,
  `prix_ht` double DEFAULT NULL,
  `remise` double DEFAULT NULL,
  `taux_tva` double DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `titre` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C26FA378F347EFB` (`produit_id`),
  KEY `IDX_C26FA378FE95D117` (`achat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `achat_retour`
--

DROP TABLE IF EXISTS `achat_retour`;
CREATE TABLE IF NOT EXISTS `achat_retour` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `achat_id` int(11) DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `num_retour` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num_avoir` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_retour` datetime DEFAULT NULL,
  `total_ht` double NOT NULL,
  `total_tva` double NOT NULL,
  `total_ttc` double NOT NULL,
  `total_remise` double DEFAULT NULL,
  `scan_bon_retour` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scan_avoir` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_comptabilise` tinyint(1) DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `compte_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_2916B3E4FE95D117` (`achat_id`),
  KEY `IDX_2916B3E4F2C56620` (`compte_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `achat_retour_produit`
--

DROP TABLE IF EXISTS `achat_retour_produit`;
CREATE TABLE IF NOT EXISTS `achat_retour_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `achat_retour_id` int(11) DEFAULT NULL,
  `achat_produit_id` int(11) DEFAULT NULL,
  `quantite` double NOT NULL,
  `prix_ht` double NOT NULL,
  `taux_tva` double DEFAULT NULL,
  `total_tva` double DEFAULT NULL,
  `taux_remise` double DEFAULT NULL,
  `total_remise` double DEFAULT NULL,
  `prix_ttc` double DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_52B4DF0FF396F54F` (`achat_retour_id`),
  KEY `IDX_52B4DF0F64846FF9` (`achat_produit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `booking`
--

DROP TABLE IF EXISTS `booking`;
CREATE TABLE IF NOT EXISTS `booking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `booking_type_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `vehicule_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `objet` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `est_honore` tinyint(1) DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `date_time_debut` datetime DEFAULT NULL,
  `date_time_fin` datetime DEFAULT NULL,
  `nom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `prenom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `matricule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `chassis` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E00CEDDEFB88E14F` (`utilisateur_id`),
  KEY `IDX_E00CEDDE9FF2C9B3` (`booking_type_id`),
  KEY `IDX_E00CEDDE19EB6921` (`client_id`),
  KEY `IDX_E00CEDDE4A4A3511` (`vehicule_id`),
  KEY `IDX_E00CEDDE20096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `booking_type`
--

DROP TABLE IF EXISTS `booking_type`;
CREATE TABLE IF NOT EXISTS `booking_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `magasin_id` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `capacite` int(11) NOT NULL,
  `duree` int(11) NOT NULL,
  `heure_debut` datetime DEFAULT NULL,
  `heure_fin` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_944F756720096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `catalogue_fournisseur`
--

DROP TABLE IF EXISTS `catalogue_fournisseur`;
CREATE TABLE IF NOT EXISTS `catalogue_fournisseur` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fournisseur_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `fichier` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_miseajour` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6CE0A3A2670C757F` (`fournisseur_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `categorie`
--

DROP TABLE IF EXISTS `categorie`;
CREATE TABLE IF NOT EXISTS `categorie` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `afficher_details_produit` tinyint(1) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_497DD634727ACA70` (`parent_id`),
  KEY `IDX_497DD63420096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `client`
--

DROP TABLE IF EXISTS `client`;
CREATE TABLE IF NOT EXISTS `client` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `raison_sociale` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `entreprise` tinyint(1) DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `adresse` longtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lng` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zoom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_inscription` datetime DEFAULT NULL,
  `patente` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ice` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `total_ht` double DEFAULT NULL,
  `total_remise` double DEFAULT NULL,
  `total_ttc` double DEFAULT NULL,
  `total_avoir` double DEFAULT NULL,
  `total_benefice` double DEFAULT NULL,
  `total_paye` double DEFAULT NULL,
  `reliquat` double DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C744045520096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `commande`
--

DROP TABLE IF EXISTS `commande`;
CREATE TABLE IF NOT EXISTS `commande` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `fournisseur_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `num_commande` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_ht` double DEFAULT NULL,
  `total_tva` double DEFAULT NULL,
  `total_ttc` double DEFAULT NULL,
  `date_commande` datetime DEFAULT NULL,
  `date_miseajour` datetime DEFAULT NULL,
  `est_cloture` tinyint(1) DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `est_facturee` tinyint(1) DEFAULT NULL,
  `date_facturation` datetime DEFAULT NULL,
  `num_increment_facture` int(11) DEFAULT NULL,
  `num_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scan_bon_commande` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `motscles` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_6EEAA67DFB88E14F` (`utilisateur_id`),
  KEY `IDX_6EEAA67D670C757F` (`fournisseur_id`),
  KEY `IDX_6EEAA67D20096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `commande_produit`
--

DROP TABLE IF EXISTS `commande_produit`;
CREATE TABLE IF NOT EXISTS `commande_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produit_id` int(11) DEFAULT NULL,
  `commande_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quantite` double NOT NULL,
  `prix_ht` double NOT NULL,
  `taux_tva` double NOT NULL,
  `total_tva` double NOT NULL,
  `taux_remise` double NOT NULL,
  `total_remise` double NOT NULL,
  `total_ht` double NOT NULL,
  `total_ttc` double NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_DF1E9E8782EA2E54` (`commande_id`),
  KEY `IDX_DF1E9E87F347EFB` (`produit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `compte`
--

DROP TABLE IF EXISTS `compte`;
CREATE TABLE IF NOT EXISTS `compte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `magasin_id` int(11) DEFAULT NULL,
  `libele` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `num_compte` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `banque` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `raison_sociale` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CFF6526020096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `contact_client`
--

DROP TABLE IF EXISTS `contact_client`;
CREATE TABLE IF NOT EXISTS `contact_client` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `prenom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `qualite` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `adresse` longtext COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_57D633D419EB6921` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `contact_fournisseur`
--

DROP TABLE IF EXISTS `contact_fournisseur`;
CREATE TABLE IF NOT EXISTS `contact_fournisseur` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fournisseur_id` int(11) DEFAULT NULL,
  `nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `prenom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `qualite` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `adresse` longtext COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5832758C670C757F` (`fournisseur_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `depense`
--

DROP TABLE IF EXISTS `depense`;
CREATE TABLE IF NOT EXISTS `depense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `montant` double NOT NULL,
  `date_depense` datetime DEFAULT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `justif` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_insertion` datetime DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `compte_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_34059757FB88E14F` (`utilisateur_id`),
  KEY `IDX_3405975720096AE3` (`magasin_id`),
  KEY `IDX_34059757F2C56620` (`compte_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `devis`
--

DROP TABLE IF EXISTS `devis`;
CREATE TABLE IF NOT EXISTS `devis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `reparation_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `num_devis` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_ht` double NOT NULL,
  `total_tva` double NOT NULL,
  `total_remise` double NOT NULL,
  `total_ttc` double NOT NULL,
  `total_benefice` double NOT NULL,
  `total_benefice_previsionnel` double DEFAULT NULL,
  `date_devis` datetime DEFAULT NULL,
  `date_miseajour` datetime DEFAULT NULL,
  `scan_devis` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_exonore` tinyint(1) DEFAULT NULL,
  `objet` longtext COLLATE utf8_unicode_ci,
  `notes` longtext COLLATE utf8_unicode_ci,
  `motscles` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_8B27C52BFB88E14F` (`utilisateur_id`),
  KEY `IDX_8B27C52B19EB6921` (`client_id`),
  KEY `IDX_8B27C52B97934BA` (`reparation_id`),
  KEY `IDX_8B27C52B20096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `devis_produit`
--

DROP TABLE IF EXISTS `devis_produit`;
CREATE TABLE IF NOT EXISTS `devis_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produit_id` int(11) DEFAULT NULL,
  `devis_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quantite` double NOT NULL,
  `prix_achat` double NOT NULL,
  `prix_ht` double NOT NULL,
  `taux_tva` double NOT NULL,
  `total_tva` double NOT NULL,
  `taux_remise` double NOT NULL,
  `total_remise` double NOT NULL,
  `total_ht` double NOT NULL,
  `total_ttc` double NOT NULL,
  `benefice` double NOT NULL,
  `benefice_previsionnel` double DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_BB4B777BF347EFB` (`produit_id`),
  KEY `IDX_BB4B777B41DEFADA` (`devis_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `droit`
--

DROP TABLE IF EXISTS `droit`;
CREATE TABLE IF NOT EXISTS `droit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entite` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `droit_utilisateur`
--

DROP TABLE IF EXISTS `droit_utilisateur`;
CREATE TABLE IF NOT EXISTS `droit_utilisateur` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `magasin_id` int(11) DEFAULT NULL,
  `droit_id` int(11) DEFAULT NULL,
  `utilisateur_id` int(11) DEFAULT NULL,
  `nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entite` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E7C0E02120096AE3` (`magasin_id`),
  KEY `IDX_E7C0E0215AA93370` (`droit_id`),
  KEY `IDX_E7C0E021FB88E14F` (`utilisateur_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `etat_produit`
--

DROP TABLE IF EXISTS `etat_produit`;
CREATE TABLE IF NOT EXISTS `etat_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produit_id` int(11) DEFAULT NULL,
  `etat_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `prix_achat` double DEFAULT NULL,
  `prix_vente` double DEFAULT NULL,
  `quantite` double DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `emplacement` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quantite_entree` double DEFAULT NULL,
  `quantite_sortie` double DEFAULT NULL,
  `quantite_initiale` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_2E7AD3A2F347EFB` (`produit_id`),
  KEY `IDX_2E7AD3A2D5E86FF` (`etat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `etat_stock`
--

DROP TABLE IF EXISTS `etat_stock`;
CREATE TABLE IF NOT EXISTS `etat_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_commande_journee` int(11) DEFAULT NULL,
  `total_vente_journee` double DEFAULT NULL,
  `total_vente_espece` double DEFAULT NULL,
  `total_vente_cheque` double DEFAULT NULL,
  `total_vente_compte` double DEFAULT NULL,
  `total_reste_journee` double DEFAULT NULL,
  `total_achat_journee` double DEFAULT NULL,
  `total_depense_journee` double DEFAULT NULL,
  `nombre_produit` double DEFAULT NULL,
  `prix_achat_total` double DEFAULT NULL,
  `prix_vente_total` double DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `date_etat` datetime DEFAULT NULL,
  `date_insertion` datetime DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `date_sortie` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DA17AD920096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `fournisseur`
--

DROP TABLE IF EXISTS `fournisseur`;
CREATE TABLE IF NOT EXISTS `fournisseur` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `raison_sociale` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `adresse` longtext COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lng` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zoom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `patente` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ice` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `total_ht` double DEFAULT NULL,
  `total_ttc` double DEFAULT NULL,
  `total_retour` double DEFAULT NULL,
  `total_paye` double DEFAULT NULL,
  `reliquat` double DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `prefix_bc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `prefix_facturation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_369ECA3220096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `magasin`
--

DROP TABLE IF EXISTS `magasin`;
CREATE TABLE IF NOT EXISTS `magasin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `adresse` longtext COLLATE utf8_unicode_ci NOT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lng` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zoom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `footer_documents` text COLLATE utf8_unicode_ci,
  `masque_num_commande` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `masque_num_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `masque_num_or` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `masque_num_avoir` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `masque_num_bl` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `papier_entete` longtext COLLATE utf8_unicode_ci,
  `afficher_entete` tinyint(1) DEFAULT NULL,
  `afficher_paiement` tinyint(1) DEFAULT NULL,
  `date_cycle` datetime DEFAULT NULL,
  `email_notification` tinyint(1) DEFAULT NULL,
  `sms_notification` tinyint(1) DEFAULT NULL,
  `whatsapp_notification` tinyint(1) DEFAULT NULL,
  `storefront` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `marque`
--

DROP TABLE IF EXISTS `marque`;
CREATE TABLE IF NOT EXISTS `marque` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `modele`
--

DROP TABLE IF EXISTS `modele`;
CREATE TABLE IF NOT EXISTS `modele` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `marque_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_100285584827B9B2` (`marque_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `modele_vente`
--

DROP TABLE IF EXISTS `modele_vente`;
CREATE TABLE IF NOT EXISTS `modele_vente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `magasin_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quantite` int(11) NOT NULL,
  `total_ht` double DEFAULT NULL,
  `total_tva` double DEFAULT NULL,
  `total_remise` double DEFAULT NULL,
  `total_apayer` double DEFAULT NULL,
  `total_benefice` double DEFAULT NULL,
  `total_paye` double DEFAULT NULL,
  `reste_apayer` double DEFAULT NULL,
  `date_commande` datetime DEFAULT NULL,
  `date_miseajour` datetime DEFAULT NULL,
  `est_facture` tinyint(1) DEFAULT NULL,
  `date_facturation` datetime DEFAULT NULL,
  `est_ferme` tinyint(1) DEFAULT NULL,
  `date_fermeture` datetime DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_2D46185320096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `modele_vente_produit`
--

DROP TABLE IF EXISTS `modele_vente_produit`;
CREATE TABLE IF NOT EXISTS `modele_vente_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produit_id` int(11) DEFAULT NULL,
  `modele_vente_id` int(11) DEFAULT NULL,
  `quantite` int(11) NOT NULL,
  `prix_ht` double NOT NULL,
  `taux_tva` double NOT NULL,
  `total_tva` double NOT NULL,
  `taux_remise` double NOT NULL,
  `total_remise` double NOT NULL,
  `prix_ttc` double NOT NULL,
  `prix_achat` double NOT NULL,
  `benefice` double NOT NULL,
  `note` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_32252912F347EFB` (`produit_id`),
  KEY `IDX_32252912151F2908` (`modele_vente_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `organisme`
--

DROP TABLE IF EXISTS `organisme`;
CREATE TABLE IF NOT EXISTS `organisme` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `raison_sociale` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `adresse` longtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `patente` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ice` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lng` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zoom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_inscription` datetime DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `paiement_achat`
--

DROP TABLE IF EXISTS `paiement_achat`;
CREATE TABLE IF NOT EXISTS `paiement_achat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `achat_id` int(11) DEFAULT NULL,
  `total_paye` double NOT NULL,
  `date_paiement` datetime DEFAULT NULL,
  `mode_paiement` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_comptabilise` tinyint(1) DEFAULT NULL,
  `date_facture` datetime DEFAULT NULL,
  `scan_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `recu_paiement` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_echeance` datetime DEFAULT NULL,
  `est_paye` tinyint(1) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `fournisseur_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `compte_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8E316149FE95D117` (`achat_id`),
  KEY `IDX_8E316149670C757F` (`fournisseur_id`),
  KEY `IDX_8E31614920096AE3` (`magasin_id`),
  KEY `IDX_8E316149F2C56620` (`compte_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `paiement_vente`
--

DROP TABLE IF EXISTS `paiement_vente`;
CREATE TABLE IF NOT EXISTS `paiement_vente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vente_id` int(11) DEFAULT NULL,
  `total_paye` double NOT NULL,
  `mode_paiement` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_echeance` datetime DEFAULT NULL,
  `date_paiement` datetime DEFAULT NULL,
  `recu_paiement` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `est_paye` tinyint(1) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_comptabilise` tinyint(1) DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `client_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `compte_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_2012CF537DC7170A` (`vente_id`),
  KEY `IDX_2012CF5319EB6921` (`client_id`),
  KEY `IDX_2012CF5320096AE3` (`magasin_id`),
  KEY `IDX_2012CF53F2C56620` (`compte_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `param`
--

DROP TABLE IF EXISTS `param`;
CREATE TABLE IF NOT EXISTS `param` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `produit`
--

DROP TABLE IF EXISTS `produit`;
CREATE TABLE IF NOT EXISTS `produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `categorie_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `marque` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `caracteristique` longtext COLLATE utf8_unicode_ci,
  `codebare` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `prix_achat` double NOT NULL,
  `prix_vente` double NOT NULL,
  `taux_tva` double NOT NULL,
  `quantite_stock` double DEFAULT NULL,
  `quantite_stock_min` double DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `prospectus` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `reference` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `est_service` tinyint(1) DEFAULT NULL,
  `modele` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `en_catalogue` tinyint(1) DEFAULT NULL,
  `emplacement` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `taxable` tinyint(1) DEFAULT NULL,
  `quantite_consigne` double DEFAULT NULL,
  `_unique` tinyint(1) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_29A5EC27BCF5E72D` (`categorie_id`),
  KEY `IDX_29A5EC2720096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `produit_attribut`
--

DROP TABLE IF EXISTS `produit_attribut`;
CREATE TABLE IF NOT EXISTS `produit_attribut` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `categorie_id` int(11) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `row_order` int(11) DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `required` tinyint(1) DEFAULT NULL,
  `global` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_53A7DA4EBCF5E72D` (`categorie_id`),
  KEY `IDX_53A7DA4EC54C8C93` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `produit_attribut_value`
--

DROP TABLE IF EXISTS `produit_attribut_value`;
CREATE TABLE IF NOT EXISTS `produit_attribut_value` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produit_id` int(11) DEFAULT NULL,
  `value` longtext COLLATE utf8_unicode_ci,
  `produitAttribut_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DF1E09191DD77C51` (`produitAttribut_id`),
  KEY `IDX_DF1E0919F347EFB` (`produit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `prospect`
--

DROP TABLE IF EXISTS `prospect`;
CREATE TABLE IF NOT EXISTS `prospect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `magasin_id` int(11) DEFAULT NULL,
  `nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `prenom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cin` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entreprise` tinyint(1) DEFAULT NULL,
  `adresse` longtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `patente` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ice` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lng` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zoom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_inscription` datetime DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `utilisateur_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C9CE8C7D20096AE3` (`magasin_id`),
  KEY `IDX_C9CE8C7DFB88E14F` (`utilisateur_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `prospect_evenement`
--

DROP TABLE IF EXISTS `prospect_evenement`;
CREATE TABLE IF NOT EXISTS `prospect_evenement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `prospect_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `date_evenement` datetime DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_F3C5BB2DFB88E14F` (`utilisateur_id`),
  KEY `IDX_F3C5BB2DD182060A` (`prospect_id`),
  KEY `IDX_F3C5BB2D20096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `reparation`
--

DROP TABLE IF EXISTS `reparation`;
CREATE TABLE IF NOT EXISTS `reparation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `vehicule_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `num_reparation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_mise_ajour` datetime DEFAULT NULL,
  `demande_client` text COLLATE utf8_unicode_ci,
  `observations` longtext COLLATE utf8_unicode_ci,
  `montant_approximatif` double DEFAULT NULL,
  `montant_reparation` double DEFAULT NULL,
  `de_garantie` tinyint(1) DEFAULT NULL,
  `est_cloturee` tinyint(1) DEFAULT NULL,
  `scan_or` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_reparation` datetime DEFAULT NULL,
  `est_valide` tinyint(1) DEFAULT NULL,
  `date_time_entree` datetime DEFAULT NULL,
  `date_time_prevue_sortie` datetime DEFAULT NULL,
  `date_time_sortie` datetime DEFAULT NULL,
  `kilometrage` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num_boite_avitesse` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_8FDF219DFB88E14F` (`utilisateur_id`),
  KEY `IDX_8FDF219D19EB6921` (`client_id`),
  KEY `IDX_8FDF219D20096AE3` (`magasin_id`),
  KEY `IDX_8FDF219D4A4A3511` (`vehicule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `reparation_piece`
--

DROP TABLE IF EXISTS `reparation_piece`;
CREATE TABLE IF NOT EXISTS `reparation_piece` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reparation_id` int(11) DEFAULT NULL,
  `titre` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `fichier` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extension` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `taille` double DEFAULT NULL,
  `date_ajout` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_7F511E497934BA` (`reparation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `reparation_produit`
--

DROP TABLE IF EXISTS `reparation_produit`;
CREATE TABLE IF NOT EXISTS `reparation_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reparation_id` int(11) DEFAULT NULL,
  `produit_id` int(11) DEFAULT NULL,
  `utilisateur_id` int(11) DEFAULT NULL,
  `quantite` double NOT NULL,
  `prix_ht` double NOT NULL,
  `taux_tva` double NOT NULL,
  `total_tva` double NOT NULL,
  `taux_remise` double NOT NULL,
  `total_remise` double DEFAULT NULL,
  `total_ttc` double NOT NULL,
  `prix_achat` double NOT NULL,
  `benefice` double NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `date_note` datetime DEFAULT NULL,
  `total_ht` double NOT NULL,
  `benefice_previsionnel` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_507C17EB97934BA` (`reparation_id`),
  KEY `IDX_507C17EBF347EFB` (`produit_id`),
  KEY `IDX_507C17EBFB88E14F` (`utilisateur_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `stock`
--

DROP TABLE IF EXISTS `stock`;
CREATE TABLE IF NOT EXISTS `stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `magasin_id` int(11) DEFAULT NULL,
  `produit_id` int(11) DEFAULT NULL,
  `quantite` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4B36566020096AE3` (`magasin_id`),
  KEY `IDX_4B365660F347EFB` (`produit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `stock_transfert`
--

DROP TABLE IF EXISTS `stock_transfert`;
CREATE TABLE IF NOT EXISTS `stock_transfert` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `depuis_stock_id` int(11) DEFAULT NULL,
  `vers_stock_id` int(11) DEFAULT NULL,
  `utilisateur_id` int(11) DEFAULT NULL,
  `quantite` int(11) DEFAULT NULL,
  `date_transfert` datetime DEFAULT NULL,
  `motif` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_86D34A53E211EEBB` (`depuis_stock_id`),
  KEY `IDX_86D34A53DBA01BB4` (`vers_stock_id`),
  KEY `IDX_86D34A53FB88E14F` (`utilisateur_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `trace`
--

DROP TABLE IF EXISTS `trace`;
CREATE TABLE IF NOT EXISTS `trace` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` longtext COLLATE utf8_unicode_ci,
  `trace_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entity_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entity_id` int(11) DEFAULT NULL,
  `ip_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` longtext COLLATE utf8_unicode_ci,
  `done_at` datetime DEFAULT NULL,
  `done_by` int(11) DEFAULT NULL,
  `os` longtext COLLATE utf8_unicode_ci,
  `browser` longtext COLLATE utf8_unicode_ci,
  `magasin_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_315BD5A1283F6D2A` (`done_by`),
  KEY `IDX_315BD5A120096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `type_attribut`
--

DROP TABLE IF EXISTS `type_attribut`;
CREATE TABLE IF NOT EXISTS `type_attribut` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `utilisateur`
--

DROP TABLE IF EXISTS `utilisateur`;
CREATE TABLE IF NOT EXISTS `utilisateur` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `prenom` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avatar` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `role` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `super_admin` tinyint(1) DEFAULT NULL,
  `remise` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `utilisateur_magasins`
--

DROP TABLE IF EXISTS `utilisateur_magasins`;
CREATE TABLE IF NOT EXISTS `utilisateur_magasins` (
  `utilisateur_id` int(11) NOT NULL,
  `magasin_id` int(11) NOT NULL,
  PRIMARY KEY (`utilisateur_id`,`magasin_id`),
  KEY `IDX_A02B2CA0FB88E14F` (`utilisateur_id`),
  KEY `IDX_A02B2CA020096AE3` (`magasin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `vehicule`
--

DROP TABLE IF EXISTS `vehicule`;
CREATE TABLE IF NOT EXISTS `vehicule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `marque` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `modele` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `immatriculation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `genre` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `energie` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `couleur` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ingredient` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `carosserie` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_mise_en_circulation` datetime DEFAULT NULL,
  `places` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `puissance_fiscale` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `kilometrage` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num_moteur` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num_chassis` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_entree` datetime DEFAULT NULL,
  `num_serie` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num_boite_avitesse` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `magasin_id` int(11) DEFAULT NULL,
  `marque_id` int(11) DEFAULT NULL,
  `modele_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_292FFF1D19EB6921` (`client_id`),
  KEY `IDX_292FFF1D20096AE3` (`magasin_id`),
  KEY `IDX_292FFF1D4827B9B2` (`marque_id`),
  KEY `IDX_292FFF1DAC14B70A` (`modele_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `vente`
--

DROP TABLE IF EXISTS `vente`;
CREATE TABLE IF NOT EXISTS `vente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utilisateur_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `magasin_id` int(11) DEFAULT NULL,
  `total_ht` double NOT NULL,
  `total_tva` double NOT NULL,
  `total_remise` double NOT NULL,
  `total_benefice` double NOT NULL,
  `total_paye` double NOT NULL,
  `date_commande` datetime DEFAULT NULL,
  `date_miseajour` datetime DEFAULT NULL,
  `date_facturation` datetime DEFAULT NULL,
  `date_comptabilisation` datetime DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `est_comptabilise` tinyint(1) DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `num_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scan_facture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_facturee` tinyint(1) DEFAULT NULL,
  `objet` longtext COLLATE utf8_unicode_ci,
  `num_commande` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_avoir` double NOT NULL,
  `num_increment_facture` int(11) DEFAULT NULL,
  `reparation_id` int(11) DEFAULT NULL,
  `motscles` longtext COLLATE utf8_unicode_ci,
  `total_ttc` double NOT NULL,
  `reliquat` double NOT NULL,
  `total_benefice_previsionnel` double DEFAULT NULL,
  `est_exonore` tinyint(1) DEFAULT NULL,
  `vente_id` int(11) DEFAULT NULL,
  `num_increment_devis` int(11) DEFAULT NULL,
  `num_devis` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scan_devis` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_interne` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_888A2A4CFB88E14F` (`utilisateur_id`),
  KEY `IDX_888A2A4C19EB6921` (`client_id`),
  KEY `IDX_888A2A4C20096AE3` (`magasin_id`),
  KEY `IDX_888A2A4C97934BA` (`reparation_id`),
  KEY `IDX_888A2A4C7DC7170A` (`vente_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `vente_livraison`
--

DROP TABLE IF EXISTS `vente_livraison`;
CREATE TABLE IF NOT EXISTS `vente_livraison` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vente_id` int(11) DEFAULT NULL,
  `num_bon_livraison` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nbr_colis` int(11) DEFAULT NULL,
  `frais_livraison` double DEFAULT NULL,
  `date_livraison` datetime DEFAULT NULL,
  `date_reception` datetime DEFAULT NULL,
  `scan_bon_livraison` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `note` longtext COLLATE utf8_unicode_ci,
  `num_increment` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1CBEC967DC7170A` (`vente_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `vente_livraison_produit`
--

DROP TABLE IF EXISTS `vente_livraison_produit`;
CREATE TABLE IF NOT EXISTS `vente_livraison_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quantite` double NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `vente_produit_id` int(11) DEFAULT NULL,
  `vente_livraison_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_364DBB889BF7820C` (`vente_produit_id`),
  KEY `IDX_364DBB8861A2A6AB` (`vente_livraison_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `vente_produit`
--

DROP TABLE IF EXISTS `vente_produit`;
CREATE TABLE IF NOT EXISTS `vente_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `produit_id` int(11) DEFAULT NULL,
  `vente_id` int(11) DEFAULT NULL,
  `quantite` double NOT NULL,
  `prix_ht` double NOT NULL,
  `taux_tva` double NOT NULL,
  `total_tva` double NOT NULL,
  `taux_remise` double NOT NULL,
  `total_remise` double NOT NULL,
  `total_ht` double NOT NULL,
  `prix_achat` double NOT NULL,
  `benefice` double NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `titre` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_ttc` double NOT NULL,
  `benefice_previsionnel` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_76AF70C7F347EFB` (`produit_id`),
  KEY `IDX_76AF70C77DC7170A` (`vente_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `vente_retour`
--

DROP TABLE IF EXISTS `vente_retour`;
CREATE TABLE IF NOT EXISTS `vente_retour` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vente_id` int(11) DEFAULT NULL,
  `num_increment` int(11) DEFAULT NULL,
  `num_retour` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_retour` datetime DEFAULT NULL,
  `total_ht` double NOT NULL,
  `total_tva` double NOT NULL,
  `total_ttc` double NOT NULL,
  `scan_bon_retour` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `est_comptabilise` tinyint(1) DEFAULT NULL,
  `total_remise` double DEFAULT NULL,
  `total_benefice` double DEFAULT NULL,
  `compte_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E27B3B187DC7170A` (`vente_id`),
  KEY `IDX_E27B3B18F2C56620` (`compte_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `vente_retour_produit`
--

DROP TABLE IF EXISTS `vente_retour_produit`;
CREATE TABLE IF NOT EXISTS `vente_retour_produit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quantite` double NOT NULL,
  `prix_ht` double NOT NULL,
  `taux_tva` double DEFAULT NULL,
  `total_tva` double DEFAULT NULL,
  `taux_remise` double DEFAULT NULL,
  `total_remise` double DEFAULT NULL,
  `prix_ttc` double DEFAULT NULL,
  `prix_achat` double DEFAULT NULL,
  `benefice` double DEFAULT NULL,
  `notes` longtext COLLATE utf8_unicode_ci,
  `vente_produit_id` int(11) DEFAULT NULL,
  `vente_retour_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6B26BFD19BF7820C` (`vente_produit_id`),
  KEY `IDX_6B26BFD18F117096` (`vente_retour_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Contraintes pour les tables déchargées
--

--
-- Contraintes pour la table `achat`
--
ALTER TABLE `achat`
  ADD CONSTRAINT `FK_26A9845620096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_26A98456670C757F` FOREIGN KEY (`fournisseur_id`) REFERENCES `fournisseur` (`id`),
  ADD CONSTRAINT `FK_26A98456FB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `achat_consignation`
--
ALTER TABLE `achat_consignation`
  ADD CONSTRAINT `FK_459EFD05FE95D117` FOREIGN KEY (`achat_id`) REFERENCES `achat` (`id`);

--
-- Contraintes pour la table `achat_consignation_produit`
--
ALTER TABLE `achat_consignation_produit`
  ADD CONSTRAINT `FK_A7DBF82D64846FF9` FOREIGN KEY (`achat_produit_id`) REFERENCES `achat_produit` (`id`),
  ADD CONSTRAINT `FK_A7DBF82DD62F262D` FOREIGN KEY (`achat_consignation_id`) REFERENCES `achat_consignation` (`id`);

--
-- Contraintes pour la table `achat_livraison`
--
ALTER TABLE `achat_livraison`
  ADD CONSTRAINT `FK_7D4C694FFE95D117` FOREIGN KEY (`achat_id`) REFERENCES `achat` (`id`);

--
-- Contraintes pour la table `achat_livraison_produit`
--
ALTER TABLE `achat_livraison_produit`
  ADD CONSTRAINT `FK_CAA63A4464846FF9` FOREIGN KEY (`achat_produit_id`) REFERENCES `achat_produit` (`id`),
  ADD CONSTRAINT `FK_CAA63A44D6D2D2E5` FOREIGN KEY (`achat_livraison_id`) REFERENCES `achat_livraison` (`id`);

--
-- Contraintes pour la table `achat_produit`
--
ALTER TABLE `achat_produit`
  ADD CONSTRAINT `FK_C26FA378F347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`),
  ADD CONSTRAINT `FK_C26FA378FE95D117` FOREIGN KEY (`achat_id`) REFERENCES `achat` (`id`);

--
-- Contraintes pour la table `achat_retour`
--
ALTER TABLE `achat_retour`
  ADD CONSTRAINT `FK_2916B3E4F2C56620` FOREIGN KEY (`compte_id`) REFERENCES `compte` (`id`),
  ADD CONSTRAINT `FK_2916B3E4FE95D117` FOREIGN KEY (`achat_id`) REFERENCES `achat` (`id`);

--
-- Contraintes pour la table `achat_retour_produit`
--
ALTER TABLE `achat_retour_produit`
  ADD CONSTRAINT `FK_52B4DF0F64846FF9` FOREIGN KEY (`achat_produit_id`) REFERENCES `achat_produit` (`id`),
  ADD CONSTRAINT `FK_52B4DF0FF396F54F` FOREIGN KEY (`achat_retour_id`) REFERENCES `achat_retour` (`id`);

--
-- Contraintes pour la table `booking`
--
ALTER TABLE `booking`
  ADD CONSTRAINT `FK_E00CEDDE19EB6921` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  ADD CONSTRAINT `FK_E00CEDDE20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_E00CEDDE4A4A3511` FOREIGN KEY (`vehicule_id`) REFERENCES `vehicule` (`id`),
  ADD CONSTRAINT `FK_E00CEDDE9FF2C9B3` FOREIGN KEY (`booking_type_id`) REFERENCES `booking_type` (`id`),
  ADD CONSTRAINT `FK_E00CEDDEFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `booking_type`
--
ALTER TABLE `booking_type`
  ADD CONSTRAINT `FK_944F756720096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`);

--
-- Contraintes pour la table `catalogue_fournisseur`
--
ALTER TABLE `catalogue_fournisseur`
  ADD CONSTRAINT `FK_6CE0A3A2670C757F` FOREIGN KEY (`fournisseur_id`) REFERENCES `fournisseur` (`id`);

--
-- Contraintes pour la table `categorie`
--
ALTER TABLE `categorie`
  ADD CONSTRAINT `FK_497DD63420096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_497DD634727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `categorie` (`id`);

--
-- Contraintes pour la table `client`
--
ALTER TABLE `client`
  ADD CONSTRAINT `FK_C744045520096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`);

--
-- Contraintes pour la table `commande`
--
ALTER TABLE `commande`
  ADD CONSTRAINT `FK_6EEAA67D20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_6EEAA67D670C757F` FOREIGN KEY (`fournisseur_id`) REFERENCES `fournisseur` (`id`),
  ADD CONSTRAINT `FK_6EEAA67DFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `commande_produit`
--
ALTER TABLE `commande_produit`
  ADD CONSTRAINT `FK_DF1E9E8782EA2E54` FOREIGN KEY (`commande_id`) REFERENCES `commande` (`id`),
  ADD CONSTRAINT `FK_DF1E9E87F347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`);

--
-- Contraintes pour la table `compte`
--
ALTER TABLE `compte`
  ADD CONSTRAINT `FK_CFF6526020096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`);

--
-- Contraintes pour la table `contact_client`
--
ALTER TABLE `contact_client`
  ADD CONSTRAINT `FK_57D633D419EB6921` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`);

--
-- Contraintes pour la table `contact_fournisseur`
--
ALTER TABLE `contact_fournisseur`
  ADD CONSTRAINT `FK_5832758C670C757F` FOREIGN KEY (`fournisseur_id`) REFERENCES `fournisseur` (`id`);

--
-- Contraintes pour la table `depense`
--
ALTER TABLE `depense`
  ADD CONSTRAINT `FK_3405975720096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_34059757F2C56620` FOREIGN KEY (`compte_id`) REFERENCES `compte` (`id`),
  ADD CONSTRAINT `FK_34059757FB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `devis`
--
ALTER TABLE `devis`
  ADD CONSTRAINT `FK_8B27C52B19EB6921` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  ADD CONSTRAINT `FK_8B27C52B20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_8B27C52B97934BA` FOREIGN KEY (`reparation_id`) REFERENCES `reparation` (`id`),
  ADD CONSTRAINT `FK_8B27C52BFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `devis_produit`
--
ALTER TABLE `devis_produit`
  ADD CONSTRAINT `FK_BB4B777B41DEFADA` FOREIGN KEY (`devis_id`) REFERENCES `devis` (`id`),
  ADD CONSTRAINT `FK_BB4B777BF347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`);

--
-- Contraintes pour la table `droit_utilisateur`
--
ALTER TABLE `droit_utilisateur`
  ADD CONSTRAINT `FK_E7C0E02120096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_E7C0E0215AA93370` FOREIGN KEY (`droit_id`) REFERENCES `droit` (`id`),
  ADD CONSTRAINT `FK_E7C0E021FB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `etat_produit`
--
ALTER TABLE `etat_produit`
  ADD CONSTRAINT `FK_2E7AD3A2D5E86FF` FOREIGN KEY (`etat_id`) REFERENCES `etat_stock` (`id`),
  ADD CONSTRAINT `FK_2E7AD3A2F347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`);

--
-- Contraintes pour la table `etat_stock`
--
ALTER TABLE `etat_stock`
  ADD CONSTRAINT `FK_DA17AD920096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`);

--
-- Contraintes pour la table `fournisseur`
--
ALTER TABLE `fournisseur`
  ADD CONSTRAINT `FK_369ECA3220096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`);

--
-- Contraintes pour la table `modele`
--
ALTER TABLE `modele`
  ADD CONSTRAINT `FK_100285584827B9B2` FOREIGN KEY (`marque_id`) REFERENCES `marque` (`id`);

--
-- Contraintes pour la table `modele_vente`
--
ALTER TABLE `modele_vente`
  ADD CONSTRAINT `FK_2D46185320096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`);

--
-- Contraintes pour la table `modele_vente_produit`
--
ALTER TABLE `modele_vente_produit`
  ADD CONSTRAINT `FK_32252912151F2908` FOREIGN KEY (`modele_vente_id`) REFERENCES `modele_vente` (`id`),
  ADD CONSTRAINT `FK_32252912F347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`);

--
-- Contraintes pour la table `paiement_achat`
--
ALTER TABLE `paiement_achat`
  ADD CONSTRAINT `FK_8E31614920096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_8E316149670C757F` FOREIGN KEY (`fournisseur_id`) REFERENCES `fournisseur` (`id`),
  ADD CONSTRAINT `FK_8E316149F2C56620` FOREIGN KEY (`compte_id`) REFERENCES `compte` (`id`),
  ADD CONSTRAINT `FK_8E316149FE95D117` FOREIGN KEY (`achat_id`) REFERENCES `achat` (`id`);

--
-- Contraintes pour la table `paiement_vente`
--
ALTER TABLE `paiement_vente`
  ADD CONSTRAINT `FK_2012CF5319EB6921` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  ADD CONSTRAINT `FK_2012CF5320096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_2012CF537DC7170A` FOREIGN KEY (`vente_id`) REFERENCES `vente` (`id`),
  ADD CONSTRAINT `FK_2012CF53F2C56620` FOREIGN KEY (`compte_id`) REFERENCES `compte` (`id`);

--
-- Contraintes pour la table `produit`
--
ALTER TABLE `produit`
  ADD CONSTRAINT `FK_29A5EC2720096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_29A5EC27BCF5E72D` FOREIGN KEY (`categorie_id`) REFERENCES `categorie` (`id`);

--
-- Contraintes pour la table `produit_attribut`
--
ALTER TABLE `produit_attribut`
  ADD CONSTRAINT `FK_53A7DA4EBCF5E72D` FOREIGN KEY (`categorie_id`) REFERENCES `categorie` (`id`),
  ADD CONSTRAINT `FK_53A7DA4EC54C8C93` FOREIGN KEY (`type_id`) REFERENCES `type_attribut` (`id`);

--
-- Contraintes pour la table `produit_attribut_value`
--
ALTER TABLE `produit_attribut_value`
  ADD CONSTRAINT `FK_DF1E09191DD77C51` FOREIGN KEY (`produitAttribut_id`) REFERENCES `produit_attribut` (`id`),
  ADD CONSTRAINT `FK_DF1E0919F347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`);

--
-- Contraintes pour la table `prospect`
--
ALTER TABLE `prospect`
  ADD CONSTRAINT `FK_C9CE8C7D20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_C9CE8C7DFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `prospect_evenement`
--
ALTER TABLE `prospect_evenement`
  ADD CONSTRAINT `FK_F3C5BB2D20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_F3C5BB2DD182060A` FOREIGN KEY (`prospect_id`) REFERENCES `prospect` (`id`),
  ADD CONSTRAINT `FK_F3C5BB2DFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `reparation`
--
ALTER TABLE `reparation`
  ADD CONSTRAINT `FK_8FDF219D19EB6921` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  ADD CONSTRAINT `FK_8FDF219D20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_8FDF219D4A4A3511` FOREIGN KEY (`vehicule_id`) REFERENCES `vehicule` (`id`),
  ADD CONSTRAINT `FK_8FDF219DFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `reparation_piece`
--
ALTER TABLE `reparation_piece`
  ADD CONSTRAINT `FK_7F511E497934BA` FOREIGN KEY (`reparation_id`) REFERENCES `reparation` (`id`);

--
-- Contraintes pour la table `reparation_produit`
--
ALTER TABLE `reparation_produit`
  ADD CONSTRAINT `FK_507C17EB97934BA` FOREIGN KEY (`reparation_id`) REFERENCES `reparation` (`id`),
  ADD CONSTRAINT `FK_507C17EBF347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`),
  ADD CONSTRAINT `FK_507C17EBFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `stock`
--
ALTER TABLE `stock`
  ADD CONSTRAINT `FK_4B36566020096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_4B365660F347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`);

--
-- Contraintes pour la table `stock_transfert`
--
ALTER TABLE `stock_transfert`
  ADD CONSTRAINT `FK_86D34A53DBA01BB4` FOREIGN KEY (`vers_stock_id`) REFERENCES `stock` (`id`),
  ADD CONSTRAINT `FK_86D34A53E211EEBB` FOREIGN KEY (`depuis_stock_id`) REFERENCES `stock` (`id`),
  ADD CONSTRAINT `FK_86D34A53FB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `trace`
--
ALTER TABLE `trace`
  ADD CONSTRAINT `FK_315BD5A120096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_315BD5A1283F6D2A` FOREIGN KEY (`done_by`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `utilisateur_magasins`
--
ALTER TABLE `utilisateur_magasins`
  ADD CONSTRAINT `FK_A02B2CA020096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_A02B2CA0FB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `vehicule`
--
ALTER TABLE `vehicule`
  ADD CONSTRAINT `FK_292FFF1D19EB6921` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  ADD CONSTRAINT `FK_292FFF1D20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_292FFF1D4827B9B2` FOREIGN KEY (`marque_id`) REFERENCES `marque` (`id`),
  ADD CONSTRAINT `FK_292FFF1DAC14B70A` FOREIGN KEY (`modele_id`) REFERENCES `modele` (`id`);

--
-- Contraintes pour la table `vente`
--
ALTER TABLE `vente`
  ADD CONSTRAINT `FK_888A2A4C19EB6921` FOREIGN KEY (`client_id`) REFERENCES `client` (`id`),
  ADD CONSTRAINT `FK_888A2A4C20096AE3` FOREIGN KEY (`magasin_id`) REFERENCES `magasin` (`id`),
  ADD CONSTRAINT `FK_888A2A4C7DC7170A` FOREIGN KEY (`vente_id`) REFERENCES `organisme` (`id`),
  ADD CONSTRAINT `FK_888A2A4C97934BA` FOREIGN KEY (`reparation_id`) REFERENCES `reparation` (`id`),
  ADD CONSTRAINT `FK_888A2A4CFB88E14F` FOREIGN KEY (`utilisateur_id`) REFERENCES `utilisateur` (`id`);

--
-- Contraintes pour la table `vente_livraison`
--
ALTER TABLE `vente_livraison`
  ADD CONSTRAINT `FK_1CBEC967DC7170A` FOREIGN KEY (`vente_id`) REFERENCES `vente` (`id`);

--
-- Contraintes pour la table `vente_livraison_produit`
--
ALTER TABLE `vente_livraison_produit`
  ADD CONSTRAINT `FK_364DBB8861A2A6AB` FOREIGN KEY (`vente_livraison_id`) REFERENCES `vente_livraison` (`id`),
  ADD CONSTRAINT `FK_364DBB889BF7820C` FOREIGN KEY (`vente_produit_id`) REFERENCES `vente_produit` (`id`);

--
-- Contraintes pour la table `vente_produit`
--
ALTER TABLE `vente_produit`
  ADD CONSTRAINT `FK_76AF70C77DC7170A` FOREIGN KEY (`vente_id`) REFERENCES `vente` (`id`),
  ADD CONSTRAINT `FK_76AF70C7F347EFB` FOREIGN KEY (`produit_id`) REFERENCES `produit` (`id`);

--
-- Contraintes pour la table `vente_retour`
--
ALTER TABLE `vente_retour`
  ADD CONSTRAINT `FK_E27B3B187DC7170A` FOREIGN KEY (`vente_id`) REFERENCES `vente` (`id`),
  ADD CONSTRAINT `FK_E27B3B18F2C56620` FOREIGN KEY (`compte_id`) REFERENCES `compte` (`id`);

--
-- Contraintes pour la table `vente_retour_produit`
--
ALTER TABLE `vente_retour_produit`
  ADD CONSTRAINT `FK_6B26BFD18F117096` FOREIGN KEY (`vente_retour_id`) REFERENCES `vente_retour` (`id`),
  ADD CONSTRAINT `FK_6B26BFD19BF7820C` FOREIGN KEY (`vente_produit_id`) REFERENCES `vente_produit` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
